% MATLAB code:  Example 1.9
% Purpose: Compute number of recurrences versus t_1 - t_j 
%          along the diagonal of the recurrence plots.
% File: sortrecur.m
%
% INPUT:
%   data = stat-logistic-n9870.dat (9,870 * 2 matrix) [-193,193]
% or
%  data = trend-logistic-n7702.dat (7,702 * 4 matrix) [-194,194]
%
% OUTPUT:
%   output ((xr+1) * 2) matrix
C********************************************************************
load data

[nr nc] = size(data);
maxd    = max(data(:,nc));

index   = linspace(-maxd,maxd,2*maxd+1);
xr      = 2*maxd;
xsort   = sort(data(:,nc));
sum     = zeros(xr+1,1);

for u=1:(xr+1)
  for i=1:nr
    j = u-((xr/2)+1);   
    if(xsort(i) == j) 
      sum(u) = sum(u)+1;
    end
  end
end

output = [index', sum];
